//! This file was generated by asn1tools version 0.145.3 Thu Jan 31 06:24:48 2019.

#[derive(Debug, PartialEq, Copy, Clone)]
pub enum Error {
    BadChoice,
    BadEnum,
    BadLength,
    OutOfData,
    OutOfMemory
}

struct Encoder<'a> {
    buf: &'a mut [u8],
    size: usize,
    pos: usize,
    error: Option<Error>
}

struct Decoder<'a> {
    buf: &'a[u8],
    size: usize,
    pos: usize,
    error: Option<Error>
}

impl<'a> Encoder<'a> {
    fn new(dst: &'a mut [u8]) -> Encoder {
        Encoder {
            size: 8 * dst.len(),
            buf: dst,
            pos: 0,
            error: None
        }
    }

    fn get_result(&self) -> Result<usize, Error> {
        if self.error.is_none() {
            return Ok((self.pos + 7) / 8);
        } else {
            return Err(self.error.unwrap());
        }
    }

    fn abort(&mut self, error: Error) {
        if self.error.is_none() {
            self.error = Some(error);
        }
    }

    fn alloc(&mut self, size: usize) -> Result<usize, ()> {
        if self.pos + size <= self.size {
            let pos = self.pos;
            self.pos += size;
            Ok(pos)
        } else {
            self.abort(Error::OutOfMemory);
            Err(())
        }
    }

    fn append_bit(&mut self, value: u8) {
        if let Ok(pos) = self.alloc(1) {
            if pos % 8 == 0 {
                self.buf[pos / 8] = 0;
            }

            self.buf[pos / 8] |= value << (7 - (pos % 8));
        }
    }

    fn append_bytes(&mut self, buf: &[u8]) {
        if let Ok(pos) = self.alloc(8 * buf.len()) {
            let byte_pos = pos / 8;
            let pos_in_byte = pos % 8;

            if pos_in_byte == 0 {
                self.buf.get_mut(byte_pos..byte_pos + buf.len())
                    .unwrap()
                    .copy_from_slice(buf.get(0..buf.len()).unwrap());
            } else {
                for i in 0..buf.len() {
                    self.buf[byte_pos + i] |= buf[i] >> pos_in_byte;
                    self.buf[byte_pos + i + 1] = buf[i] << (8 - pos_in_byte);
                }
            }
        }
    }

    fn append_u8(&mut self, value: u8) {
        self.append_bytes(&value.to_be_bytes());
    }

    fn append_u16(&mut self, value: u16) {
        self.append_bytes(&value.to_be_bytes());
    }

    fn append_u32(&mut self, value: u32) {
        self.append_bytes(&value.to_be_bytes());
    }

    fn append_u64(&mut self, value: u64) {
        self.append_bytes(&value.to_be_bytes());
    }

    fn append_i8(&mut self, value: i8) {
        self.append_u8((value as u8).wrapping_add(128));
    }

    fn append_i16(&mut self, value: i16) {
        self.append_u16((value as u16).wrapping_add(32768));
    }

    fn append_i32(&mut self, value: i32) {
        self.append_u32((value as u32).wrapping_add(2147483648));
    }

    fn append_i64(&mut self, value: i64) {
        self.append_u64((value as u64).wrapping_add(9223372036854775808));
    }

    fn append_bool(&mut self, value: bool) {
        self.append_bit(value as u8);
    }

    fn append_non_negative_binary_integer(&mut self, value: u64, size: usize) {
        for i in 0..size {
            self.append_bit((value >> (size - i - 1)) as u8 & 1);
        }
    }
}

impl<'a> Decoder<'a> {
    fn new(src: &'a[u8]) -> Decoder {
        Decoder {
            buf: src,
            size: 8 * src.len(),
            pos: 0,
            error: None
        }
    }

    fn get_result(&self) -> Result<usize, Error> {
        if self.error.is_none() {
            Ok((self.pos + 7) / 8)
        } else {
            Err(self.error.unwrap())
        }
    }

    fn abort(&mut self, error: Error) {
        if self.error.is_none() {
            self.error = Some(error);
        }
    }

    fn free(&mut self, size: usize) -> Result<usize, ()> {
        if self.pos + size <= self.size {
            let pos = self.pos;
            self.pos += size;
            Ok(pos)
        } else {
            self.abort(Error::OutOfData);
            Err(())
        }
    }

    fn read_bit(&mut self) -> u8 {
        if let Ok(pos) = self.free(1) {
            (self.buf[pos / 8] >> (7 - (pos % 8))) & 1
        } else {
            0
        }
    }

    fn read_bytes(&mut self, buf: &mut [u8]) {
        if let Ok(pos) = self.free(8 * buf.len()) {
            let byte_pos = pos / 8;
            let pos_in_byte = pos % 8;

            if pos_in_byte == 0 {
                buf.copy_from_slice(
                    self.buf.get(byte_pos..byte_pos + buf.len()).unwrap());
            } else {
                for i in 0..buf.len() {
                    buf[i] = self.buf[byte_pos + i] << pos_in_byte;
                    buf[i] |= self.buf[byte_pos + i + 1] >> (8 - pos_in_byte);
                }
            }
        }
    }

    fn read_u8(&mut self) -> u8 {
        let mut buf = [0; 1];

        self.read_bytes(&mut buf);

        u8::from_be_bytes(buf)
    }

    fn read_u16(&mut self) -> u16 {
        let mut buf = [0; 2];

        self.read_bytes(&mut buf);

        u16::from_be_bytes(buf)
    }

    fn read_u32(&mut self) -> u32 {
        let mut buf = [0; 4];

        self.read_bytes(&mut buf);

        u32::from_be_bytes(buf)
    }

    fn read_u64(&mut self) -> u64 {
        let mut buf = [0; 8];

        self.read_bytes(&mut buf);

        u64::from_be_bytes(buf)
    }

    fn read_i8(&mut self) -> i8 {
        self.read_u8().wrapping_sub(128) as i8
    }

    fn read_i16(&mut self) -> i16 {
        self.read_u16().wrapping_sub(32768) as i16
    }

    fn read_i32(&mut self) -> i32 {
        self.read_u32().wrapping_sub(2147483648) as i32
    }

    fn read_i64(&mut self) -> i64 {
        self.read_u64().wrapping_sub(9223372036854775808) as i64
    }

    fn read_bool(&mut self) -> bool {
        self.read_bit() != 0
    }

    fn read_non_negative_binary_integer(&mut self, size: usize) -> u64 {
        let mut value: u64 = 0;

        for _ in 0..size {
            value <<= 1;
            value |= self.read_bit() as u64;
        }

        value
    }
}

/// Type A in module RustSource.
#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceAJ {
    pub buf: [u8; 11]
}

#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceA {
    pub a: i8,
    pub b: i16,
    pub c: i32,
    pub d: i64,
    pub e: u8,
    pub f: u16,
    pub g: u32,
    pub h: u64,
    pub i: bool,
    pub j: RustSourceAJ
}

impl RustSourceA {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_i8(self.a);
        encoder.append_i16(self.b);
        encoder.append_i32(self.c);
        encoder.append_i64(self.d);
        encoder.append_u8(self.e);
        encoder.append_u16(self.f);
        encoder.append_u32(self.g);
        encoder.append_u64(self.h);
        encoder.append_bool(self.i);
        encoder.append_bytes(&self.j.buf);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.a = decoder.read_i8();
        self.b = decoder.read_i16();
        self.c = decoder.read_i32();
        self.d = decoder.read_i64();
        self.e = decoder.read_u8();
        self.f = decoder.read_u16();
        self.g = decoder.read_u32();
        self.h = decoder.read_u64();
        self.i = decoder.read_bool();
        decoder.read_bytes(&mut self.j.buf);
    }
}

/// Type AB in module RustSource.
#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceAB {
    pub a: i8,
    pub b: u16
}

impl RustSourceAB {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.a - -1) as u64,
            1);
        encoder.append_non_negative_binary_integer(
            (self.b - 10000) as u64,
            10);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.a = decoder.read_non_negative_binary_integer(1) as i8;
        self.a += -1;
        self.b = decoder.read_non_negative_binary_integer(10) as u16;
        self.b += 10000;
    }
}

/// Type D in module RustSource.
let length: u8;
#[derive(Debug, PartialEq, Copy, Clone)]
pub enum RustSourceDElemAB {
    C(u8),
    D(bool)
}

struct {
    let length: u8;
}

#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceDElemA {
    pub b: RustSourceDElemAB,
    pub e: RustSourceDElemAE
}

#[derive(Debug, PartialEq, Copy, Clone)]
pub enum RustSourceDElemGH {
    I,
    J,
    K,
}

impl Default for RustSourceDElemGH {
    fn default() -> Self {
        RustSourceDElemGH::I
    }
}

#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceDElemGL {
    let length: u8;
    pub buf: [u8; 2]
}

#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceDElemG {
    pub h: RustSourceDElemGH,
    pub l: RustSourceDElemGL
}

#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceDElemMPQ {
    pub buf: [u8; 5]
}

#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceDElemMP {
    pub q: RustSourceDElemMPQ,
    pub is_r_present: bool,
    pub r: bool
}

#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceDElemM {
    pub is_n_present: bool,
    pub n: bool,
    pub o: i8,
    pub is_p_present: bool,
    pub p: RustSourceDElemMP
}

#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceDElem {
    pub a: RustSourceDElemA,
    pub g: RustSourceDElemG,
    pub m: RustSourceDElemM
} elements[10];

impl RustSourceD {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.length - 1) as u64,
            4);

        for i in 0..self.length {
            match self {
                C(choice) => {
                    encoder.append_non_negative_binary_integer(0, 1);
                    encoder.append_non_negative_binary_integer(
                        (self.elements[i].a.b.c - 0) as u64,
                        1);
                },
                D(choice) => {
                    encoder.append_non_negative_binary_integer(1, 1);
                    encoder.append_bool(self.elements[i].a.b.d);
                },
                _ => encoder.abort(Error::BadChoice);
            }

            encoder.append_non_negative_binary_integer(
                (self.elements[i].a.e.length - 3) as u64,
                1);

            for i_2 in 0..self.elements[i].a.e.length {
            }

            encoder.append_non_negative_binary_integer(self.elements[i].g.h, 2);
            encoder.append_non_negative_binary_integer(
                (self.elements[i].g.l.length - 1) as u64,
                1);
            encoder.append_bytes(&self.elements[i].g.l.buf,
                                 self.elements[i].g.l.length);
            encoder.append_bit(self.elements[i].m.is_n_present as u8);
            encoder.append_bit((self.elements[i].m.o != 3) as u8);
            encoder.append_bit(self.elements[i].m.is_p_present as u8);

            if src.elements[i].m.is_n_present {
                encoder.append_bool(self.elements[i].m.n);
            }

            if src.elements[i].m.o != 3 {
                encoder.append_non_negative_binary_integer(
                    (self.elements[i].m.o - -2) as u64,
                    3);
            }

            if src.elements[i].m.is_p_present {
                encoder.append_bit(self.elements[i].m.p.is_r_present as u8);
                encoder.append_bytes(&self.elements[i].m.p.q.buf);

                if src.elements[i].m.p.is_r_present {
                    encoder.append_bool(self.elements[i].m.p.r);
                }
            }
        }
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.length = decoder.read_non_negative_binary_integer(4);
        self.length += 1;

        if self.length > 10 {
            decoder.abort(Error::BadLength);

            return;
        }

        for i in 0..self.length {
            match decoder.read_non_negative_binary_integer(1) {
                0 => {
                    self.elements[i].a.b.choice = RustSourceDABC;
                    self.elements[i].a.b.c = decoder.read_non_negative_binary_integer(1) as u8;
                    self.elements[i].a.b.c += 0;
                },
                1 => {
                    self.elements[i].a.b.choice = RustSourceDABD;
                    self.elements[i].a.b.d = decoder.read_bool();
                },
                _ => decoder.abort(Error::BadChoice);
            }

            self.elements[i].a.e.length = decoder.read_non_negative_binary_integer(1);
            self.elements[i].a.e.length += 3;

            for i_2 in 0..self.elements[i].a.e.length {
            }

            self.elements[i].g.h = decoder.read_non_negative_binary_integer(2);
            self.elements[i].g.l.length = decoder.read_non_negative_binary_integer(
                1);
            self.elements[i].g.l.length += 1;
            decoder.read_bytes(&mut self.elements[i].g.l.buf,
                               self.elements[i].g.l.length);
            self.elements[i].m.is_n_present = decoder.read_bit() != 0;
            is_present = decoder.read_bit() == 1;
            self.elements[i].m.is_p_present = decoder.read_bit() != 0;

            if dst.elements[i].m.is_n_present {
                self.elements[i].m.n = decoder.read_bool();
            }

            if is_present {
                self.elements[i].m.o = decoder.read_non_negative_binary_integer(3) as i8;
                self.elements[i].m.o += -2;
            } else {
                dst.elements[i].m.o = 3;
            }

            if dst.elements[i].m.is_p_present {
                self.elements[i].m.p.is_r_present = decoder.read_bit() != 0;
                decoder.read_bytes(&mut self.elements[i].m.p.q.buf);

                if dst.elements[i].m.p.is_r_present {
                    self.elements[i].m.p.r = decoder.read_bool();
                }
            }
        }
    }
}

/// Type Q in module RustSource.
#[derive(Debug, PartialEq, Copy, Clone)]
pub enum RustSourceQ {
    C001(bool),
    C002(bool),
    C003(bool),
    C004(bool),
    C005(bool),
    C006(bool),
    C007(bool),
    C008(bool),
    C009(bool),
    C010(bool),
    C011(bool),
    C012(bool),
    C013(bool),
    C014(bool),
    C015(bool),
    C016(bool),
    C017(bool),
    C018(bool),
    C019(bool),
    C020(bool),
    C021(bool),
    C022(bool),
    C023(bool),
    C024(bool),
    C025(bool),
    C026(bool),
    C027(bool),
    C028(bool),
    C029(bool),
    C030(bool),
    C031(bool),
    C032(bool),
    C033(bool),
    C034(bool),
    C035(bool),
    C036(bool),
    C037(bool),
    C038(bool),
    C039(bool),
    C040(bool),
    C041(bool),
    C042(bool),
    C043(bool),
    C044(bool),
    C045(bool),
    C046(bool),
    C047(bool),
    C048(bool),
    C049(bool),
    C050(bool),
    C051(bool),
    C052(bool),
    C053(bool),
    C054(bool),
    C055(bool),
    C056(bool),
    C057(bool),
    C058(bool),
    C059(bool),
    C060(bool),
    C061(bool),
    C062(bool),
    C063(bool),
    C064(bool),
    C065(bool),
    C066(bool),
    C067(bool),
    C068(bool),
    C069(bool),
    C070(bool),
    C071(bool),
    C072(bool),
    C073(bool),
    C074(bool),
    C075(bool),
    C076(bool),
    C077(bool),
    C078(bool),
    C079(bool),
    C080(bool),
    C081(bool),
    C082(bool),
    C083(bool),
    C084(bool),
    C085(bool),
    C086(bool),
    C087(bool),
    C088(bool),
    C089(bool),
    C090(bool),
    C091(bool),
    C092(bool),
    C093(bool),
    C094(bool),
    C095(bool),
    C096(bool),
    C097(bool),
    C098(bool),
    C099(bool),
    C100(bool),
    C101(bool),
    C102(bool),
    C103(bool),
    C104(bool),
    C105(bool),
    C106(bool),
    C107(bool),
    C108(bool),
    C109(bool),
    C110(bool),
    C111(bool),
    C112(bool),
    C113(bool),
    C114(bool),
    C115(bool),
    C116(bool),
    C117(bool),
    C118(bool),
    C119(bool),
    C120(bool),
    C121(bool),
    C122(bool),
    C123(bool),
    C124(bool),
    C125(bool),
    C126(bool),
    C127(bool),
    C128(bool),
    C129(bool),
    C130(bool),
    C131(bool),
    C132(bool),
    C133(bool),
    C134(bool),
    C135(bool),
    C136(bool),
    C137(bool),
    C138(bool),
    C139(bool),
    C140(bool),
    C141(bool),
    C142(bool),
    C143(bool),
    C144(bool),
    C145(bool),
    C146(bool),
    C147(bool),
    C148(bool),
    C149(bool),
    C150(bool),
    C151(bool),
    C152(bool),
    C153(bool),
    C154(bool),
    C155(bool),
    C156(bool),
    C157(bool),
    C158(bool),
    C159(bool),
    C160(bool),
    C161(bool),
    C162(bool),
    C163(bool),
    C164(bool),
    C165(bool),
    C166(bool),
    C167(bool),
    C168(bool),
    C169(bool),
    C170(bool),
    C171(bool),
    C172(bool),
    C173(bool),
    C174(bool),
    C175(bool),
    C176(bool),
    C177(bool),
    C178(bool),
    C179(bool),
    C180(bool),
    C181(bool),
    C182(bool),
    C183(bool),
    C184(bool),
    C185(bool),
    C186(bool),
    C187(bool),
    C188(bool),
    C189(bool),
    C190(bool),
    C191(bool),
    C192(bool),
    C193(bool),
    C194(bool),
    C195(bool),
    C196(bool),
    C197(bool),
    C198(bool),
    C199(bool),
    C200(bool),
    C201(bool),
    C202(bool),
    C203(bool),
    C204(bool),
    C205(bool),
    C206(bool),
    C207(bool),
    C208(bool),
    C209(bool),
    C210(bool),
    C211(bool),
    C212(bool),
    C213(bool),
    C214(bool),
    C215(bool),
    C216(bool),
    C217(bool),
    C218(bool),
    C219(bool),
    C220(bool),
    C221(bool),
    C222(bool),
    C223(bool),
    C224(bool),
    C225(bool),
    C226(bool),
    C227(bool),
    C228(bool),
    C229(bool),
    C230(bool),
    C231(bool),
    C232(bool),
    C233(bool),
    C234(bool),
    C235(bool),
    C236(bool),
    C237(bool),
    C238(bool),
    C239(bool),
    C240(bool),
    C241(bool),
    C242(bool),
    C243(bool),
    C244(bool),
    C245(bool),
    C246(bool),
    C247(bool),
    C248(bool),
    C249(bool),
    C250(bool),
    C251(bool),
    C252(bool),
    C253(bool),
    C254(bool),
    C255(bool),
    C256(bool),
    C257(bool)
}

impl RustSourceQ {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        match self {
            C001(choice) => {
                encoder.append_non_negative_binary_integer(0, 9);
                encoder.append_bool(self.c001);
            },
            C002(choice) => {
                encoder.append_non_negative_binary_integer(1, 9);
                encoder.append_bool(self.c002);
            },
            C003(choice) => {
                encoder.append_non_negative_binary_integer(2, 9);
                encoder.append_bool(self.c003);
            },
            C004(choice) => {
                encoder.append_non_negative_binary_integer(3, 9);
                encoder.append_bool(self.c004);
            },
            C005(choice) => {
                encoder.append_non_negative_binary_integer(4, 9);
                encoder.append_bool(self.c005);
            },
            C006(choice) => {
                encoder.append_non_negative_binary_integer(5, 9);
                encoder.append_bool(self.c006);
            },
            C007(choice) => {
                encoder.append_non_negative_binary_integer(6, 9);
                encoder.append_bool(self.c007);
            },
            C008(choice) => {
                encoder.append_non_negative_binary_integer(7, 9);
                encoder.append_bool(self.c008);
            },
            C009(choice) => {
                encoder.append_non_negative_binary_integer(8, 9);
                encoder.append_bool(self.c009);
            },
            C010(choice) => {
                encoder.append_non_negative_binary_integer(9, 9);
                encoder.append_bool(self.c010);
            },
            C011(choice) => {
                encoder.append_non_negative_binary_integer(10, 9);
                encoder.append_bool(self.c011);
            },
            C012(choice) => {
                encoder.append_non_negative_binary_integer(11, 9);
                encoder.append_bool(self.c012);
            },
            C013(choice) => {
                encoder.append_non_negative_binary_integer(12, 9);
                encoder.append_bool(self.c013);
            },
            C014(choice) => {
                encoder.append_non_negative_binary_integer(13, 9);
                encoder.append_bool(self.c014);
            },
            C015(choice) => {
                encoder.append_non_negative_binary_integer(14, 9);
                encoder.append_bool(self.c015);
            },
            C016(choice) => {
                encoder.append_non_negative_binary_integer(15, 9);
                encoder.append_bool(self.c016);
            },
            C017(choice) => {
                encoder.append_non_negative_binary_integer(16, 9);
                encoder.append_bool(self.c017);
            },
            C018(choice) => {
                encoder.append_non_negative_binary_integer(17, 9);
                encoder.append_bool(self.c018);
            },
            C019(choice) => {
                encoder.append_non_negative_binary_integer(18, 9);
                encoder.append_bool(self.c019);
            },
            C020(choice) => {
                encoder.append_non_negative_binary_integer(19, 9);
                encoder.append_bool(self.c020);
            },
            C021(choice) => {
                encoder.append_non_negative_binary_integer(20, 9);
                encoder.append_bool(self.c021);
            },
            C022(choice) => {
                encoder.append_non_negative_binary_integer(21, 9);
                encoder.append_bool(self.c022);
            },
            C023(choice) => {
                encoder.append_non_negative_binary_integer(22, 9);
                encoder.append_bool(self.c023);
            },
            C024(choice) => {
                encoder.append_non_negative_binary_integer(23, 9);
                encoder.append_bool(self.c024);
            },
            C025(choice) => {
                encoder.append_non_negative_binary_integer(24, 9);
                encoder.append_bool(self.c025);
            },
            C026(choice) => {
                encoder.append_non_negative_binary_integer(25, 9);
                encoder.append_bool(self.c026);
            },
            C027(choice) => {
                encoder.append_non_negative_binary_integer(26, 9);
                encoder.append_bool(self.c027);
            },
            C028(choice) => {
                encoder.append_non_negative_binary_integer(27, 9);
                encoder.append_bool(self.c028);
            },
            C029(choice) => {
                encoder.append_non_negative_binary_integer(28, 9);
                encoder.append_bool(self.c029);
            },
            C030(choice) => {
                encoder.append_non_negative_binary_integer(29, 9);
                encoder.append_bool(self.c030);
            },
            C031(choice) => {
                encoder.append_non_negative_binary_integer(30, 9);
                encoder.append_bool(self.c031);
            },
            C032(choice) => {
                encoder.append_non_negative_binary_integer(31, 9);
                encoder.append_bool(self.c032);
            },
            C033(choice) => {
                encoder.append_non_negative_binary_integer(32, 9);
                encoder.append_bool(self.c033);
            },
            C034(choice) => {
                encoder.append_non_negative_binary_integer(33, 9);
                encoder.append_bool(self.c034);
            },
            C035(choice) => {
                encoder.append_non_negative_binary_integer(34, 9);
                encoder.append_bool(self.c035);
            },
            C036(choice) => {
                encoder.append_non_negative_binary_integer(35, 9);
                encoder.append_bool(self.c036);
            },
            C037(choice) => {
                encoder.append_non_negative_binary_integer(36, 9);
                encoder.append_bool(self.c037);
            },
            C038(choice) => {
                encoder.append_non_negative_binary_integer(37, 9);
                encoder.append_bool(self.c038);
            },
            C039(choice) => {
                encoder.append_non_negative_binary_integer(38, 9);
                encoder.append_bool(self.c039);
            },
            C040(choice) => {
                encoder.append_non_negative_binary_integer(39, 9);
                encoder.append_bool(self.c040);
            },
            C041(choice) => {
                encoder.append_non_negative_binary_integer(40, 9);
                encoder.append_bool(self.c041);
            },
            C042(choice) => {
                encoder.append_non_negative_binary_integer(41, 9);
                encoder.append_bool(self.c042);
            },
            C043(choice) => {
                encoder.append_non_negative_binary_integer(42, 9);
                encoder.append_bool(self.c043);
            },
            C044(choice) => {
                encoder.append_non_negative_binary_integer(43, 9);
                encoder.append_bool(self.c044);
            },
            C045(choice) => {
                encoder.append_non_negative_binary_integer(44, 9);
                encoder.append_bool(self.c045);
            },
            C046(choice) => {
                encoder.append_non_negative_binary_integer(45, 9);
                encoder.append_bool(self.c046);
            },
            C047(choice) => {
                encoder.append_non_negative_binary_integer(46, 9);
                encoder.append_bool(self.c047);
            },
            C048(choice) => {
                encoder.append_non_negative_binary_integer(47, 9);
                encoder.append_bool(self.c048);
            },
            C049(choice) => {
                encoder.append_non_negative_binary_integer(48, 9);
                encoder.append_bool(self.c049);
            },
            C050(choice) => {
                encoder.append_non_negative_binary_integer(49, 9);
                encoder.append_bool(self.c050);
            },
            C051(choice) => {
                encoder.append_non_negative_binary_integer(50, 9);
                encoder.append_bool(self.c051);
            },
            C052(choice) => {
                encoder.append_non_negative_binary_integer(51, 9);
                encoder.append_bool(self.c052);
            },
            C053(choice) => {
                encoder.append_non_negative_binary_integer(52, 9);
                encoder.append_bool(self.c053);
            },
            C054(choice) => {
                encoder.append_non_negative_binary_integer(53, 9);
                encoder.append_bool(self.c054);
            },
            C055(choice) => {
                encoder.append_non_negative_binary_integer(54, 9);
                encoder.append_bool(self.c055);
            },
            C056(choice) => {
                encoder.append_non_negative_binary_integer(55, 9);
                encoder.append_bool(self.c056);
            },
            C057(choice) => {
                encoder.append_non_negative_binary_integer(56, 9);
                encoder.append_bool(self.c057);
            },
            C058(choice) => {
                encoder.append_non_negative_binary_integer(57, 9);
                encoder.append_bool(self.c058);
            },
            C059(choice) => {
                encoder.append_non_negative_binary_integer(58, 9);
                encoder.append_bool(self.c059);
            },
            C060(choice) => {
                encoder.append_non_negative_binary_integer(59, 9);
                encoder.append_bool(self.c060);
            },
            C061(choice) => {
                encoder.append_non_negative_binary_integer(60, 9);
                encoder.append_bool(self.c061);
            },
            C062(choice) => {
                encoder.append_non_negative_binary_integer(61, 9);
                encoder.append_bool(self.c062);
            },
            C063(choice) => {
                encoder.append_non_negative_binary_integer(62, 9);
                encoder.append_bool(self.c063);
            },
            C064(choice) => {
                encoder.append_non_negative_binary_integer(63, 9);
                encoder.append_bool(self.c064);
            },
            C065(choice) => {
                encoder.append_non_negative_binary_integer(64, 9);
                encoder.append_bool(self.c065);
            },
            C066(choice) => {
                encoder.append_non_negative_binary_integer(65, 9);
                encoder.append_bool(self.c066);
            },
            C067(choice) => {
                encoder.append_non_negative_binary_integer(66, 9);
                encoder.append_bool(self.c067);
            },
            C068(choice) => {
                encoder.append_non_negative_binary_integer(67, 9);
                encoder.append_bool(self.c068);
            },
            C069(choice) => {
                encoder.append_non_negative_binary_integer(68, 9);
                encoder.append_bool(self.c069);
            },
            C070(choice) => {
                encoder.append_non_negative_binary_integer(69, 9);
                encoder.append_bool(self.c070);
            },
            C071(choice) => {
                encoder.append_non_negative_binary_integer(70, 9);
                encoder.append_bool(self.c071);
            },
            C072(choice) => {
                encoder.append_non_negative_binary_integer(71, 9);
                encoder.append_bool(self.c072);
            },
            C073(choice) => {
                encoder.append_non_negative_binary_integer(72, 9);
                encoder.append_bool(self.c073);
            },
            C074(choice) => {
                encoder.append_non_negative_binary_integer(73, 9);
                encoder.append_bool(self.c074);
            },
            C075(choice) => {
                encoder.append_non_negative_binary_integer(74, 9);
                encoder.append_bool(self.c075);
            },
            C076(choice) => {
                encoder.append_non_negative_binary_integer(75, 9);
                encoder.append_bool(self.c076);
            },
            C077(choice) => {
                encoder.append_non_negative_binary_integer(76, 9);
                encoder.append_bool(self.c077);
            },
            C078(choice) => {
                encoder.append_non_negative_binary_integer(77, 9);
                encoder.append_bool(self.c078);
            },
            C079(choice) => {
                encoder.append_non_negative_binary_integer(78, 9);
                encoder.append_bool(self.c079);
            },
            C080(choice) => {
                encoder.append_non_negative_binary_integer(79, 9);
                encoder.append_bool(self.c080);
            },
            C081(choice) => {
                encoder.append_non_negative_binary_integer(80, 9);
                encoder.append_bool(self.c081);
            },
            C082(choice) => {
                encoder.append_non_negative_binary_integer(81, 9);
                encoder.append_bool(self.c082);
            },
            C083(choice) => {
                encoder.append_non_negative_binary_integer(82, 9);
                encoder.append_bool(self.c083);
            },
            C084(choice) => {
                encoder.append_non_negative_binary_integer(83, 9);
                encoder.append_bool(self.c084);
            },
            C085(choice) => {
                encoder.append_non_negative_binary_integer(84, 9);
                encoder.append_bool(self.c085);
            },
            C086(choice) => {
                encoder.append_non_negative_binary_integer(85, 9);
                encoder.append_bool(self.c086);
            },
            C087(choice) => {
                encoder.append_non_negative_binary_integer(86, 9);
                encoder.append_bool(self.c087);
            },
            C088(choice) => {
                encoder.append_non_negative_binary_integer(87, 9);
                encoder.append_bool(self.c088);
            },
            C089(choice) => {
                encoder.append_non_negative_binary_integer(88, 9);
                encoder.append_bool(self.c089);
            },
            C090(choice) => {
                encoder.append_non_negative_binary_integer(89, 9);
                encoder.append_bool(self.c090);
            },
            C091(choice) => {
                encoder.append_non_negative_binary_integer(90, 9);
                encoder.append_bool(self.c091);
            },
            C092(choice) => {
                encoder.append_non_negative_binary_integer(91, 9);
                encoder.append_bool(self.c092);
            },
            C093(choice) => {
                encoder.append_non_negative_binary_integer(92, 9);
                encoder.append_bool(self.c093);
            },
            C094(choice) => {
                encoder.append_non_negative_binary_integer(93, 9);
                encoder.append_bool(self.c094);
            },
            C095(choice) => {
                encoder.append_non_negative_binary_integer(94, 9);
                encoder.append_bool(self.c095);
            },
            C096(choice) => {
                encoder.append_non_negative_binary_integer(95, 9);
                encoder.append_bool(self.c096);
            },
            C097(choice) => {
                encoder.append_non_negative_binary_integer(96, 9);
                encoder.append_bool(self.c097);
            },
            C098(choice) => {
                encoder.append_non_negative_binary_integer(97, 9);
                encoder.append_bool(self.c098);
            },
            C099(choice) => {
                encoder.append_non_negative_binary_integer(98, 9);
                encoder.append_bool(self.c099);
            },
            C100(choice) => {
                encoder.append_non_negative_binary_integer(99, 9);
                encoder.append_bool(self.c100);
            },
            C101(choice) => {
                encoder.append_non_negative_binary_integer(100, 9);
                encoder.append_bool(self.c101);
            },
            C102(choice) => {
                encoder.append_non_negative_binary_integer(101, 9);
                encoder.append_bool(self.c102);
            },
            C103(choice) => {
                encoder.append_non_negative_binary_integer(102, 9);
                encoder.append_bool(self.c103);
            },
            C104(choice) => {
                encoder.append_non_negative_binary_integer(103, 9);
                encoder.append_bool(self.c104);
            },
            C105(choice) => {
                encoder.append_non_negative_binary_integer(104, 9);
                encoder.append_bool(self.c105);
            },
            C106(choice) => {
                encoder.append_non_negative_binary_integer(105, 9);
                encoder.append_bool(self.c106);
            },
            C107(choice) => {
                encoder.append_non_negative_binary_integer(106, 9);
                encoder.append_bool(self.c107);
            },
            C108(choice) => {
                encoder.append_non_negative_binary_integer(107, 9);
                encoder.append_bool(self.c108);
            },
            C109(choice) => {
                encoder.append_non_negative_binary_integer(108, 9);
                encoder.append_bool(self.c109);
            },
            C110(choice) => {
                encoder.append_non_negative_binary_integer(109, 9);
                encoder.append_bool(self.c110);
            },
            C111(choice) => {
                encoder.append_non_negative_binary_integer(110, 9);
                encoder.append_bool(self.c111);
            },
            C112(choice) => {
                encoder.append_non_negative_binary_integer(111, 9);
                encoder.append_bool(self.c112);
            },
            C113(choice) => {
                encoder.append_non_negative_binary_integer(112, 9);
                encoder.append_bool(self.c113);
            },
            C114(choice) => {
                encoder.append_non_negative_binary_integer(113, 9);
                encoder.append_bool(self.c114);
            },
            C115(choice) => {
                encoder.append_non_negative_binary_integer(114, 9);
                encoder.append_bool(self.c115);
            },
            C116(choice) => {
                encoder.append_non_negative_binary_integer(115, 9);
                encoder.append_bool(self.c116);
            },
            C117(choice) => {
                encoder.append_non_negative_binary_integer(116, 9);
                encoder.append_bool(self.c117);
            },
            C118(choice) => {
                encoder.append_non_negative_binary_integer(117, 9);
                encoder.append_bool(self.c118);
            },
            C119(choice) => {
                encoder.append_non_negative_binary_integer(118, 9);
                encoder.append_bool(self.c119);
            },
            C120(choice) => {
                encoder.append_non_negative_binary_integer(119, 9);
                encoder.append_bool(self.c120);
            },
            C121(choice) => {
                encoder.append_non_negative_binary_integer(120, 9);
                encoder.append_bool(self.c121);
            },
            C122(choice) => {
                encoder.append_non_negative_binary_integer(121, 9);
                encoder.append_bool(self.c122);
            },
            C123(choice) => {
                encoder.append_non_negative_binary_integer(122, 9);
                encoder.append_bool(self.c123);
            },
            C124(choice) => {
                encoder.append_non_negative_binary_integer(123, 9);
                encoder.append_bool(self.c124);
            },
            C125(choice) => {
                encoder.append_non_negative_binary_integer(124, 9);
                encoder.append_bool(self.c125);
            },
            C126(choice) => {
                encoder.append_non_negative_binary_integer(125, 9);
                encoder.append_bool(self.c126);
            },
            C127(choice) => {
                encoder.append_non_negative_binary_integer(126, 9);
                encoder.append_bool(self.c127);
            },
            C128(choice) => {
                encoder.append_non_negative_binary_integer(127, 9);
                encoder.append_bool(self.c128);
            },
            C129(choice) => {
                encoder.append_non_negative_binary_integer(128, 9);
                encoder.append_bool(self.c129);
            },
            C130(choice) => {
                encoder.append_non_negative_binary_integer(129, 9);
                encoder.append_bool(self.c130);
            },
            C131(choice) => {
                encoder.append_non_negative_binary_integer(130, 9);
                encoder.append_bool(self.c131);
            },
            C132(choice) => {
                encoder.append_non_negative_binary_integer(131, 9);
                encoder.append_bool(self.c132);
            },
            C133(choice) => {
                encoder.append_non_negative_binary_integer(132, 9);
                encoder.append_bool(self.c133);
            },
            C134(choice) => {
                encoder.append_non_negative_binary_integer(133, 9);
                encoder.append_bool(self.c134);
            },
            C135(choice) => {
                encoder.append_non_negative_binary_integer(134, 9);
                encoder.append_bool(self.c135);
            },
            C136(choice) => {
                encoder.append_non_negative_binary_integer(135, 9);
                encoder.append_bool(self.c136);
            },
            C137(choice) => {
                encoder.append_non_negative_binary_integer(136, 9);
                encoder.append_bool(self.c137);
            },
            C138(choice) => {
                encoder.append_non_negative_binary_integer(137, 9);
                encoder.append_bool(self.c138);
            },
            C139(choice) => {
                encoder.append_non_negative_binary_integer(138, 9);
                encoder.append_bool(self.c139);
            },
            C140(choice) => {
                encoder.append_non_negative_binary_integer(139, 9);
                encoder.append_bool(self.c140);
            },
            C141(choice) => {
                encoder.append_non_negative_binary_integer(140, 9);
                encoder.append_bool(self.c141);
            },
            C142(choice) => {
                encoder.append_non_negative_binary_integer(141, 9);
                encoder.append_bool(self.c142);
            },
            C143(choice) => {
                encoder.append_non_negative_binary_integer(142, 9);
                encoder.append_bool(self.c143);
            },
            C144(choice) => {
                encoder.append_non_negative_binary_integer(143, 9);
                encoder.append_bool(self.c144);
            },
            C145(choice) => {
                encoder.append_non_negative_binary_integer(144, 9);
                encoder.append_bool(self.c145);
            },
            C146(choice) => {
                encoder.append_non_negative_binary_integer(145, 9);
                encoder.append_bool(self.c146);
            },
            C147(choice) => {
                encoder.append_non_negative_binary_integer(146, 9);
                encoder.append_bool(self.c147);
            },
            C148(choice) => {
                encoder.append_non_negative_binary_integer(147, 9);
                encoder.append_bool(self.c148);
            },
            C149(choice) => {
                encoder.append_non_negative_binary_integer(148, 9);
                encoder.append_bool(self.c149);
            },
            C150(choice) => {
                encoder.append_non_negative_binary_integer(149, 9);
                encoder.append_bool(self.c150);
            },
            C151(choice) => {
                encoder.append_non_negative_binary_integer(150, 9);
                encoder.append_bool(self.c151);
            },
            C152(choice) => {
                encoder.append_non_negative_binary_integer(151, 9);
                encoder.append_bool(self.c152);
            },
            C153(choice) => {
                encoder.append_non_negative_binary_integer(152, 9);
                encoder.append_bool(self.c153);
            },
            C154(choice) => {
                encoder.append_non_negative_binary_integer(153, 9);
                encoder.append_bool(self.c154);
            },
            C155(choice) => {
                encoder.append_non_negative_binary_integer(154, 9);
                encoder.append_bool(self.c155);
            },
            C156(choice) => {
                encoder.append_non_negative_binary_integer(155, 9);
                encoder.append_bool(self.c156);
            },
            C157(choice) => {
                encoder.append_non_negative_binary_integer(156, 9);
                encoder.append_bool(self.c157);
            },
            C158(choice) => {
                encoder.append_non_negative_binary_integer(157, 9);
                encoder.append_bool(self.c158);
            },
            C159(choice) => {
                encoder.append_non_negative_binary_integer(158, 9);
                encoder.append_bool(self.c159);
            },
            C160(choice) => {
                encoder.append_non_negative_binary_integer(159, 9);
                encoder.append_bool(self.c160);
            },
            C161(choice) => {
                encoder.append_non_negative_binary_integer(160, 9);
                encoder.append_bool(self.c161);
            },
            C162(choice) => {
                encoder.append_non_negative_binary_integer(161, 9);
                encoder.append_bool(self.c162);
            },
            C163(choice) => {
                encoder.append_non_negative_binary_integer(162, 9);
                encoder.append_bool(self.c163);
            },
            C164(choice) => {
                encoder.append_non_negative_binary_integer(163, 9);
                encoder.append_bool(self.c164);
            },
            C165(choice) => {
                encoder.append_non_negative_binary_integer(164, 9);
                encoder.append_bool(self.c165);
            },
            C166(choice) => {
                encoder.append_non_negative_binary_integer(165, 9);
                encoder.append_bool(self.c166);
            },
            C167(choice) => {
                encoder.append_non_negative_binary_integer(166, 9);
                encoder.append_bool(self.c167);
            },
            C168(choice) => {
                encoder.append_non_negative_binary_integer(167, 9);
                encoder.append_bool(self.c168);
            },
            C169(choice) => {
                encoder.append_non_negative_binary_integer(168, 9);
                encoder.append_bool(self.c169);
            },
            C170(choice) => {
                encoder.append_non_negative_binary_integer(169, 9);
                encoder.append_bool(self.c170);
            },
            C171(choice) => {
                encoder.append_non_negative_binary_integer(170, 9);
                encoder.append_bool(self.c171);
            },
            C172(choice) => {
                encoder.append_non_negative_binary_integer(171, 9);
                encoder.append_bool(self.c172);
            },
            C173(choice) => {
                encoder.append_non_negative_binary_integer(172, 9);
                encoder.append_bool(self.c173);
            },
            C174(choice) => {
                encoder.append_non_negative_binary_integer(173, 9);
                encoder.append_bool(self.c174);
            },
            C175(choice) => {
                encoder.append_non_negative_binary_integer(174, 9);
                encoder.append_bool(self.c175);
            },
            C176(choice) => {
                encoder.append_non_negative_binary_integer(175, 9);
                encoder.append_bool(self.c176);
            },
            C177(choice) => {
                encoder.append_non_negative_binary_integer(176, 9);
                encoder.append_bool(self.c177);
            },
            C178(choice) => {
                encoder.append_non_negative_binary_integer(177, 9);
                encoder.append_bool(self.c178);
            },
            C179(choice) => {
                encoder.append_non_negative_binary_integer(178, 9);
                encoder.append_bool(self.c179);
            },
            C180(choice) => {
                encoder.append_non_negative_binary_integer(179, 9);
                encoder.append_bool(self.c180);
            },
            C181(choice) => {
                encoder.append_non_negative_binary_integer(180, 9);
                encoder.append_bool(self.c181);
            },
            C182(choice) => {
                encoder.append_non_negative_binary_integer(181, 9);
                encoder.append_bool(self.c182);
            },
            C183(choice) => {
                encoder.append_non_negative_binary_integer(182, 9);
                encoder.append_bool(self.c183);
            },
            C184(choice) => {
                encoder.append_non_negative_binary_integer(183, 9);
                encoder.append_bool(self.c184);
            },
            C185(choice) => {
                encoder.append_non_negative_binary_integer(184, 9);
                encoder.append_bool(self.c185);
            },
            C186(choice) => {
                encoder.append_non_negative_binary_integer(185, 9);
                encoder.append_bool(self.c186);
            },
            C187(choice) => {
                encoder.append_non_negative_binary_integer(186, 9);
                encoder.append_bool(self.c187);
            },
            C188(choice) => {
                encoder.append_non_negative_binary_integer(187, 9);
                encoder.append_bool(self.c188);
            },
            C189(choice) => {
                encoder.append_non_negative_binary_integer(188, 9);
                encoder.append_bool(self.c189);
            },
            C190(choice) => {
                encoder.append_non_negative_binary_integer(189, 9);
                encoder.append_bool(self.c190);
            },
            C191(choice) => {
                encoder.append_non_negative_binary_integer(190, 9);
                encoder.append_bool(self.c191);
            },
            C192(choice) => {
                encoder.append_non_negative_binary_integer(191, 9);
                encoder.append_bool(self.c192);
            },
            C193(choice) => {
                encoder.append_non_negative_binary_integer(192, 9);
                encoder.append_bool(self.c193);
            },
            C194(choice) => {
                encoder.append_non_negative_binary_integer(193, 9);
                encoder.append_bool(self.c194);
            },
            C195(choice) => {
                encoder.append_non_negative_binary_integer(194, 9);
                encoder.append_bool(self.c195);
            },
            C196(choice) => {
                encoder.append_non_negative_binary_integer(195, 9);
                encoder.append_bool(self.c196);
            },
            C197(choice) => {
                encoder.append_non_negative_binary_integer(196, 9);
                encoder.append_bool(self.c197);
            },
            C198(choice) => {
                encoder.append_non_negative_binary_integer(197, 9);
                encoder.append_bool(self.c198);
            },
            C199(choice) => {
                encoder.append_non_negative_binary_integer(198, 9);
                encoder.append_bool(self.c199);
            },
            C200(choice) => {
                encoder.append_non_negative_binary_integer(199, 9);
                encoder.append_bool(self.c200);
            },
            C201(choice) => {
                encoder.append_non_negative_binary_integer(200, 9);
                encoder.append_bool(self.c201);
            },
            C202(choice) => {
                encoder.append_non_negative_binary_integer(201, 9);
                encoder.append_bool(self.c202);
            },
            C203(choice) => {
                encoder.append_non_negative_binary_integer(202, 9);
                encoder.append_bool(self.c203);
            },
            C204(choice) => {
                encoder.append_non_negative_binary_integer(203, 9);
                encoder.append_bool(self.c204);
            },
            C205(choice) => {
                encoder.append_non_negative_binary_integer(204, 9);
                encoder.append_bool(self.c205);
            },
            C206(choice) => {
                encoder.append_non_negative_binary_integer(205, 9);
                encoder.append_bool(self.c206);
            },
            C207(choice) => {
                encoder.append_non_negative_binary_integer(206, 9);
                encoder.append_bool(self.c207);
            },
            C208(choice) => {
                encoder.append_non_negative_binary_integer(207, 9);
                encoder.append_bool(self.c208);
            },
            C209(choice) => {
                encoder.append_non_negative_binary_integer(208, 9);
                encoder.append_bool(self.c209);
            },
            C210(choice) => {
                encoder.append_non_negative_binary_integer(209, 9);
                encoder.append_bool(self.c210);
            },
            C211(choice) => {
                encoder.append_non_negative_binary_integer(210, 9);
                encoder.append_bool(self.c211);
            },
            C212(choice) => {
                encoder.append_non_negative_binary_integer(211, 9);
                encoder.append_bool(self.c212);
            },
            C213(choice) => {
                encoder.append_non_negative_binary_integer(212, 9);
                encoder.append_bool(self.c213);
            },
            C214(choice) => {
                encoder.append_non_negative_binary_integer(213, 9);
                encoder.append_bool(self.c214);
            },
            C215(choice) => {
                encoder.append_non_negative_binary_integer(214, 9);
                encoder.append_bool(self.c215);
            },
            C216(choice) => {
                encoder.append_non_negative_binary_integer(215, 9);
                encoder.append_bool(self.c216);
            },
            C217(choice) => {
                encoder.append_non_negative_binary_integer(216, 9);
                encoder.append_bool(self.c217);
            },
            C218(choice) => {
                encoder.append_non_negative_binary_integer(217, 9);
                encoder.append_bool(self.c218);
            },
            C219(choice) => {
                encoder.append_non_negative_binary_integer(218, 9);
                encoder.append_bool(self.c219);
            },
            C220(choice) => {
                encoder.append_non_negative_binary_integer(219, 9);
                encoder.append_bool(self.c220);
            },
            C221(choice) => {
                encoder.append_non_negative_binary_integer(220, 9);
                encoder.append_bool(self.c221);
            },
            C222(choice) => {
                encoder.append_non_negative_binary_integer(221, 9);
                encoder.append_bool(self.c222);
            },
            C223(choice) => {
                encoder.append_non_negative_binary_integer(222, 9);
                encoder.append_bool(self.c223);
            },
            C224(choice) => {
                encoder.append_non_negative_binary_integer(223, 9);
                encoder.append_bool(self.c224);
            },
            C225(choice) => {
                encoder.append_non_negative_binary_integer(224, 9);
                encoder.append_bool(self.c225);
            },
            C226(choice) => {
                encoder.append_non_negative_binary_integer(225, 9);
                encoder.append_bool(self.c226);
            },
            C227(choice) => {
                encoder.append_non_negative_binary_integer(226, 9);
                encoder.append_bool(self.c227);
            },
            C228(choice) => {
                encoder.append_non_negative_binary_integer(227, 9);
                encoder.append_bool(self.c228);
            },
            C229(choice) => {
                encoder.append_non_negative_binary_integer(228, 9);
                encoder.append_bool(self.c229);
            },
            C230(choice) => {
                encoder.append_non_negative_binary_integer(229, 9);
                encoder.append_bool(self.c230);
            },
            C231(choice) => {
                encoder.append_non_negative_binary_integer(230, 9);
                encoder.append_bool(self.c231);
            },
            C232(choice) => {
                encoder.append_non_negative_binary_integer(231, 9);
                encoder.append_bool(self.c232);
            },
            C233(choice) => {
                encoder.append_non_negative_binary_integer(232, 9);
                encoder.append_bool(self.c233);
            },
            C234(choice) => {
                encoder.append_non_negative_binary_integer(233, 9);
                encoder.append_bool(self.c234);
            },
            C235(choice) => {
                encoder.append_non_negative_binary_integer(234, 9);
                encoder.append_bool(self.c235);
            },
            C236(choice) => {
                encoder.append_non_negative_binary_integer(235, 9);
                encoder.append_bool(self.c236);
            },
            C237(choice) => {
                encoder.append_non_negative_binary_integer(236, 9);
                encoder.append_bool(self.c237);
            },
            C238(choice) => {
                encoder.append_non_negative_binary_integer(237, 9);
                encoder.append_bool(self.c238);
            },
            C239(choice) => {
                encoder.append_non_negative_binary_integer(238, 9);
                encoder.append_bool(self.c239);
            },
            C240(choice) => {
                encoder.append_non_negative_binary_integer(239, 9);
                encoder.append_bool(self.c240);
            },
            C241(choice) => {
                encoder.append_non_negative_binary_integer(240, 9);
                encoder.append_bool(self.c241);
            },
            C242(choice) => {
                encoder.append_non_negative_binary_integer(241, 9);
                encoder.append_bool(self.c242);
            },
            C243(choice) => {
                encoder.append_non_negative_binary_integer(242, 9);
                encoder.append_bool(self.c243);
            },
            C244(choice) => {
                encoder.append_non_negative_binary_integer(243, 9);
                encoder.append_bool(self.c244);
            },
            C245(choice) => {
                encoder.append_non_negative_binary_integer(244, 9);
                encoder.append_bool(self.c245);
            },
            C246(choice) => {
                encoder.append_non_negative_binary_integer(245, 9);
                encoder.append_bool(self.c246);
            },
            C247(choice) => {
                encoder.append_non_negative_binary_integer(246, 9);
                encoder.append_bool(self.c247);
            },
            C248(choice) => {
                encoder.append_non_negative_binary_integer(247, 9);
                encoder.append_bool(self.c248);
            },
            C249(choice) => {
                encoder.append_non_negative_binary_integer(248, 9);
                encoder.append_bool(self.c249);
            },
            C250(choice) => {
                encoder.append_non_negative_binary_integer(249, 9);
                encoder.append_bool(self.c250);
            },
            C251(choice) => {
                encoder.append_non_negative_binary_integer(250, 9);
                encoder.append_bool(self.c251);
            },
            C252(choice) => {
                encoder.append_non_negative_binary_integer(251, 9);
                encoder.append_bool(self.c252);
            },
            C253(choice) => {
                encoder.append_non_negative_binary_integer(252, 9);
                encoder.append_bool(self.c253);
            },
            C254(choice) => {
                encoder.append_non_negative_binary_integer(253, 9);
                encoder.append_bool(self.c254);
            },
            C255(choice) => {
                encoder.append_non_negative_binary_integer(254, 9);
                encoder.append_bool(self.c255);
            },
            C256(choice) => {
                encoder.append_non_negative_binary_integer(255, 9);
                encoder.append_bool(self.c256);
            },
            C257(choice) => {
                encoder.append_non_negative_binary_integer(256, 9);
                encoder.append_bool(self.c257);
            },
            _ => encoder.abort(Error::BadChoice);
        }
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        match decoder.read_non_negative_binary_integer(9) {
            0 => {
                self.choice = RustSourceQC001;
                self.c001 = decoder.read_bool();
            },
            1 => {
                self.choice = RustSourceQC002;
                self.c002 = decoder.read_bool();
            },
            2 => {
                self.choice = RustSourceQC003;
                self.c003 = decoder.read_bool();
            },
            3 => {
                self.choice = RustSourceQC004;
                self.c004 = decoder.read_bool();
            },
            4 => {
                self.choice = RustSourceQC005;
                self.c005 = decoder.read_bool();
            },
            5 => {
                self.choice = RustSourceQC006;
                self.c006 = decoder.read_bool();
            },
            6 => {
                self.choice = RustSourceQC007;
                self.c007 = decoder.read_bool();
            },
            7 => {
                self.choice = RustSourceQC008;
                self.c008 = decoder.read_bool();
            },
            8 => {
                self.choice = RustSourceQC009;
                self.c009 = decoder.read_bool();
            },
            9 => {
                self.choice = RustSourceQC010;
                self.c010 = decoder.read_bool();
            },
            10 => {
                self.choice = RustSourceQC011;
                self.c011 = decoder.read_bool();
            },
            11 => {
                self.choice = RustSourceQC012;
                self.c012 = decoder.read_bool();
            },
            12 => {
                self.choice = RustSourceQC013;
                self.c013 = decoder.read_bool();
            },
            13 => {
                self.choice = RustSourceQC014;
                self.c014 = decoder.read_bool();
            },
            14 => {
                self.choice = RustSourceQC015;
                self.c015 = decoder.read_bool();
            },
            15 => {
                self.choice = RustSourceQC016;
                self.c016 = decoder.read_bool();
            },
            16 => {
                self.choice = RustSourceQC017;
                self.c017 = decoder.read_bool();
            },
            17 => {
                self.choice = RustSourceQC018;
                self.c018 = decoder.read_bool();
            },
            18 => {
                self.choice = RustSourceQC019;
                self.c019 = decoder.read_bool();
            },
            19 => {
                self.choice = RustSourceQC020;
                self.c020 = decoder.read_bool();
            },
            20 => {
                self.choice = RustSourceQC021;
                self.c021 = decoder.read_bool();
            },
            21 => {
                self.choice = RustSourceQC022;
                self.c022 = decoder.read_bool();
            },
            22 => {
                self.choice = RustSourceQC023;
                self.c023 = decoder.read_bool();
            },
            23 => {
                self.choice = RustSourceQC024;
                self.c024 = decoder.read_bool();
            },
            24 => {
                self.choice = RustSourceQC025;
                self.c025 = decoder.read_bool();
            },
            25 => {
                self.choice = RustSourceQC026;
                self.c026 = decoder.read_bool();
            },
            26 => {
                self.choice = RustSourceQC027;
                self.c027 = decoder.read_bool();
            },
            27 => {
                self.choice = RustSourceQC028;
                self.c028 = decoder.read_bool();
            },
            28 => {
                self.choice = RustSourceQC029;
                self.c029 = decoder.read_bool();
            },
            29 => {
                self.choice = RustSourceQC030;
                self.c030 = decoder.read_bool();
            },
            30 => {
                self.choice = RustSourceQC031;
                self.c031 = decoder.read_bool();
            },
            31 => {
                self.choice = RustSourceQC032;
                self.c032 = decoder.read_bool();
            },
            32 => {
                self.choice = RustSourceQC033;
                self.c033 = decoder.read_bool();
            },
            33 => {
                self.choice = RustSourceQC034;
                self.c034 = decoder.read_bool();
            },
            34 => {
                self.choice = RustSourceQC035;
                self.c035 = decoder.read_bool();
            },
            35 => {
                self.choice = RustSourceQC036;
                self.c036 = decoder.read_bool();
            },
            36 => {
                self.choice = RustSourceQC037;
                self.c037 = decoder.read_bool();
            },
            37 => {
                self.choice = RustSourceQC038;
                self.c038 = decoder.read_bool();
            },
            38 => {
                self.choice = RustSourceQC039;
                self.c039 = decoder.read_bool();
            },
            39 => {
                self.choice = RustSourceQC040;
                self.c040 = decoder.read_bool();
            },
            40 => {
                self.choice = RustSourceQC041;
                self.c041 = decoder.read_bool();
            },
            41 => {
                self.choice = RustSourceQC042;
                self.c042 = decoder.read_bool();
            },
            42 => {
                self.choice = RustSourceQC043;
                self.c043 = decoder.read_bool();
            },
            43 => {
                self.choice = RustSourceQC044;
                self.c044 = decoder.read_bool();
            },
            44 => {
                self.choice = RustSourceQC045;
                self.c045 = decoder.read_bool();
            },
            45 => {
                self.choice = RustSourceQC046;
                self.c046 = decoder.read_bool();
            },
            46 => {
                self.choice = RustSourceQC047;
                self.c047 = decoder.read_bool();
            },
            47 => {
                self.choice = RustSourceQC048;
                self.c048 = decoder.read_bool();
            },
            48 => {
                self.choice = RustSourceQC049;
                self.c049 = decoder.read_bool();
            },
            49 => {
                self.choice = RustSourceQC050;
                self.c050 = decoder.read_bool();
            },
            50 => {
                self.choice = RustSourceQC051;
                self.c051 = decoder.read_bool();
            },
            51 => {
                self.choice = RustSourceQC052;
                self.c052 = decoder.read_bool();
            },
            52 => {
                self.choice = RustSourceQC053;
                self.c053 = decoder.read_bool();
            },
            53 => {
                self.choice = RustSourceQC054;
                self.c054 = decoder.read_bool();
            },
            54 => {
                self.choice = RustSourceQC055;
                self.c055 = decoder.read_bool();
            },
            55 => {
                self.choice = RustSourceQC056;
                self.c056 = decoder.read_bool();
            },
            56 => {
                self.choice = RustSourceQC057;
                self.c057 = decoder.read_bool();
            },
            57 => {
                self.choice = RustSourceQC058;
                self.c058 = decoder.read_bool();
            },
            58 => {
                self.choice = RustSourceQC059;
                self.c059 = decoder.read_bool();
            },
            59 => {
                self.choice = RustSourceQC060;
                self.c060 = decoder.read_bool();
            },
            60 => {
                self.choice = RustSourceQC061;
                self.c061 = decoder.read_bool();
            },
            61 => {
                self.choice = RustSourceQC062;
                self.c062 = decoder.read_bool();
            },
            62 => {
                self.choice = RustSourceQC063;
                self.c063 = decoder.read_bool();
            },
            63 => {
                self.choice = RustSourceQC064;
                self.c064 = decoder.read_bool();
            },
            64 => {
                self.choice = RustSourceQC065;
                self.c065 = decoder.read_bool();
            },
            65 => {
                self.choice = RustSourceQC066;
                self.c066 = decoder.read_bool();
            },
            66 => {
                self.choice = RustSourceQC067;
                self.c067 = decoder.read_bool();
            },
            67 => {
                self.choice = RustSourceQC068;
                self.c068 = decoder.read_bool();
            },
            68 => {
                self.choice = RustSourceQC069;
                self.c069 = decoder.read_bool();
            },
            69 => {
                self.choice = RustSourceQC070;
                self.c070 = decoder.read_bool();
            },
            70 => {
                self.choice = RustSourceQC071;
                self.c071 = decoder.read_bool();
            },
            71 => {
                self.choice = RustSourceQC072;
                self.c072 = decoder.read_bool();
            },
            72 => {
                self.choice = RustSourceQC073;
                self.c073 = decoder.read_bool();
            },
            73 => {
                self.choice = RustSourceQC074;
                self.c074 = decoder.read_bool();
            },
            74 => {
                self.choice = RustSourceQC075;
                self.c075 = decoder.read_bool();
            },
            75 => {
                self.choice = RustSourceQC076;
                self.c076 = decoder.read_bool();
            },
            76 => {
                self.choice = RustSourceQC077;
                self.c077 = decoder.read_bool();
            },
            77 => {
                self.choice = RustSourceQC078;
                self.c078 = decoder.read_bool();
            },
            78 => {
                self.choice = RustSourceQC079;
                self.c079 = decoder.read_bool();
            },
            79 => {
                self.choice = RustSourceQC080;
                self.c080 = decoder.read_bool();
            },
            80 => {
                self.choice = RustSourceQC081;
                self.c081 = decoder.read_bool();
            },
            81 => {
                self.choice = RustSourceQC082;
                self.c082 = decoder.read_bool();
            },
            82 => {
                self.choice = RustSourceQC083;
                self.c083 = decoder.read_bool();
            },
            83 => {
                self.choice = RustSourceQC084;
                self.c084 = decoder.read_bool();
            },
            84 => {
                self.choice = RustSourceQC085;
                self.c085 = decoder.read_bool();
            },
            85 => {
                self.choice = RustSourceQC086;
                self.c086 = decoder.read_bool();
            },
            86 => {
                self.choice = RustSourceQC087;
                self.c087 = decoder.read_bool();
            },
            87 => {
                self.choice = RustSourceQC088;
                self.c088 = decoder.read_bool();
            },
            88 => {
                self.choice = RustSourceQC089;
                self.c089 = decoder.read_bool();
            },
            89 => {
                self.choice = RustSourceQC090;
                self.c090 = decoder.read_bool();
            },
            90 => {
                self.choice = RustSourceQC091;
                self.c091 = decoder.read_bool();
            },
            91 => {
                self.choice = RustSourceQC092;
                self.c092 = decoder.read_bool();
            },
            92 => {
                self.choice = RustSourceQC093;
                self.c093 = decoder.read_bool();
            },
            93 => {
                self.choice = RustSourceQC094;
                self.c094 = decoder.read_bool();
            },
            94 => {
                self.choice = RustSourceQC095;
                self.c095 = decoder.read_bool();
            },
            95 => {
                self.choice = RustSourceQC096;
                self.c096 = decoder.read_bool();
            },
            96 => {
                self.choice = RustSourceQC097;
                self.c097 = decoder.read_bool();
            },
            97 => {
                self.choice = RustSourceQC098;
                self.c098 = decoder.read_bool();
            },
            98 => {
                self.choice = RustSourceQC099;
                self.c099 = decoder.read_bool();
            },
            99 => {
                self.choice = RustSourceQC100;
                self.c100 = decoder.read_bool();
            },
            100 => {
                self.choice = RustSourceQC101;
                self.c101 = decoder.read_bool();
            },
            101 => {
                self.choice = RustSourceQC102;
                self.c102 = decoder.read_bool();
            },
            102 => {
                self.choice = RustSourceQC103;
                self.c103 = decoder.read_bool();
            },
            103 => {
                self.choice = RustSourceQC104;
                self.c104 = decoder.read_bool();
            },
            104 => {
                self.choice = RustSourceQC105;
                self.c105 = decoder.read_bool();
            },
            105 => {
                self.choice = RustSourceQC106;
                self.c106 = decoder.read_bool();
            },
            106 => {
                self.choice = RustSourceQC107;
                self.c107 = decoder.read_bool();
            },
            107 => {
                self.choice = RustSourceQC108;
                self.c108 = decoder.read_bool();
            },
            108 => {
                self.choice = RustSourceQC109;
                self.c109 = decoder.read_bool();
            },
            109 => {
                self.choice = RustSourceQC110;
                self.c110 = decoder.read_bool();
            },
            110 => {
                self.choice = RustSourceQC111;
                self.c111 = decoder.read_bool();
            },
            111 => {
                self.choice = RustSourceQC112;
                self.c112 = decoder.read_bool();
            },
            112 => {
                self.choice = RustSourceQC113;
                self.c113 = decoder.read_bool();
            },
            113 => {
                self.choice = RustSourceQC114;
                self.c114 = decoder.read_bool();
            },
            114 => {
                self.choice = RustSourceQC115;
                self.c115 = decoder.read_bool();
            },
            115 => {
                self.choice = RustSourceQC116;
                self.c116 = decoder.read_bool();
            },
            116 => {
                self.choice = RustSourceQC117;
                self.c117 = decoder.read_bool();
            },
            117 => {
                self.choice = RustSourceQC118;
                self.c118 = decoder.read_bool();
            },
            118 => {
                self.choice = RustSourceQC119;
                self.c119 = decoder.read_bool();
            },
            119 => {
                self.choice = RustSourceQC120;
                self.c120 = decoder.read_bool();
            },
            120 => {
                self.choice = RustSourceQC121;
                self.c121 = decoder.read_bool();
            },
            121 => {
                self.choice = RustSourceQC122;
                self.c122 = decoder.read_bool();
            },
            122 => {
                self.choice = RustSourceQC123;
                self.c123 = decoder.read_bool();
            },
            123 => {
                self.choice = RustSourceQC124;
                self.c124 = decoder.read_bool();
            },
            124 => {
                self.choice = RustSourceQC125;
                self.c125 = decoder.read_bool();
            },
            125 => {
                self.choice = RustSourceQC126;
                self.c126 = decoder.read_bool();
            },
            126 => {
                self.choice = RustSourceQC127;
                self.c127 = decoder.read_bool();
            },
            127 => {
                self.choice = RustSourceQC128;
                self.c128 = decoder.read_bool();
            },
            128 => {
                self.choice = RustSourceQC129;
                self.c129 = decoder.read_bool();
            },
            129 => {
                self.choice = RustSourceQC130;
                self.c130 = decoder.read_bool();
            },
            130 => {
                self.choice = RustSourceQC131;
                self.c131 = decoder.read_bool();
            },
            131 => {
                self.choice = RustSourceQC132;
                self.c132 = decoder.read_bool();
            },
            132 => {
                self.choice = RustSourceQC133;
                self.c133 = decoder.read_bool();
            },
            133 => {
                self.choice = RustSourceQC134;
                self.c134 = decoder.read_bool();
            },
            134 => {
                self.choice = RustSourceQC135;
                self.c135 = decoder.read_bool();
            },
            135 => {
                self.choice = RustSourceQC136;
                self.c136 = decoder.read_bool();
            },
            136 => {
                self.choice = RustSourceQC137;
                self.c137 = decoder.read_bool();
            },
            137 => {
                self.choice = RustSourceQC138;
                self.c138 = decoder.read_bool();
            },
            138 => {
                self.choice = RustSourceQC139;
                self.c139 = decoder.read_bool();
            },
            139 => {
                self.choice = RustSourceQC140;
                self.c140 = decoder.read_bool();
            },
            140 => {
                self.choice = RustSourceQC141;
                self.c141 = decoder.read_bool();
            },
            141 => {
                self.choice = RustSourceQC142;
                self.c142 = decoder.read_bool();
            },
            142 => {
                self.choice = RustSourceQC143;
                self.c143 = decoder.read_bool();
            },
            143 => {
                self.choice = RustSourceQC144;
                self.c144 = decoder.read_bool();
            },
            144 => {
                self.choice = RustSourceQC145;
                self.c145 = decoder.read_bool();
            },
            145 => {
                self.choice = RustSourceQC146;
                self.c146 = decoder.read_bool();
            },
            146 => {
                self.choice = RustSourceQC147;
                self.c147 = decoder.read_bool();
            },
            147 => {
                self.choice = RustSourceQC148;
                self.c148 = decoder.read_bool();
            },
            148 => {
                self.choice = RustSourceQC149;
                self.c149 = decoder.read_bool();
            },
            149 => {
                self.choice = RustSourceQC150;
                self.c150 = decoder.read_bool();
            },
            150 => {
                self.choice = RustSourceQC151;
                self.c151 = decoder.read_bool();
            },
            151 => {
                self.choice = RustSourceQC152;
                self.c152 = decoder.read_bool();
            },
            152 => {
                self.choice = RustSourceQC153;
                self.c153 = decoder.read_bool();
            },
            153 => {
                self.choice = RustSourceQC154;
                self.c154 = decoder.read_bool();
            },
            154 => {
                self.choice = RustSourceQC155;
                self.c155 = decoder.read_bool();
            },
            155 => {
                self.choice = RustSourceQC156;
                self.c156 = decoder.read_bool();
            },
            156 => {
                self.choice = RustSourceQC157;
                self.c157 = decoder.read_bool();
            },
            157 => {
                self.choice = RustSourceQC158;
                self.c158 = decoder.read_bool();
            },
            158 => {
                self.choice = RustSourceQC159;
                self.c159 = decoder.read_bool();
            },
            159 => {
                self.choice = RustSourceQC160;
                self.c160 = decoder.read_bool();
            },
            160 => {
                self.choice = RustSourceQC161;
                self.c161 = decoder.read_bool();
            },
            161 => {
                self.choice = RustSourceQC162;
                self.c162 = decoder.read_bool();
            },
            162 => {
                self.choice = RustSourceQC163;
                self.c163 = decoder.read_bool();
            },
            163 => {
                self.choice = RustSourceQC164;
                self.c164 = decoder.read_bool();
            },
            164 => {
                self.choice = RustSourceQC165;
                self.c165 = decoder.read_bool();
            },
            165 => {
                self.choice = RustSourceQC166;
                self.c166 = decoder.read_bool();
            },
            166 => {
                self.choice = RustSourceQC167;
                self.c167 = decoder.read_bool();
            },
            167 => {
                self.choice = RustSourceQC168;
                self.c168 = decoder.read_bool();
            },
            168 => {
                self.choice = RustSourceQC169;
                self.c169 = decoder.read_bool();
            },
            169 => {
                self.choice = RustSourceQC170;
                self.c170 = decoder.read_bool();
            },
            170 => {
                self.choice = RustSourceQC171;
                self.c171 = decoder.read_bool();
            },
            171 => {
                self.choice = RustSourceQC172;
                self.c172 = decoder.read_bool();
            },
            172 => {
                self.choice = RustSourceQC173;
                self.c173 = decoder.read_bool();
            },
            173 => {
                self.choice = RustSourceQC174;
                self.c174 = decoder.read_bool();
            },
            174 => {
                self.choice = RustSourceQC175;
                self.c175 = decoder.read_bool();
            },
            175 => {
                self.choice = RustSourceQC176;
                self.c176 = decoder.read_bool();
            },
            176 => {
                self.choice = RustSourceQC177;
                self.c177 = decoder.read_bool();
            },
            177 => {
                self.choice = RustSourceQC178;
                self.c178 = decoder.read_bool();
            },
            178 => {
                self.choice = RustSourceQC179;
                self.c179 = decoder.read_bool();
            },
            179 => {
                self.choice = RustSourceQC180;
                self.c180 = decoder.read_bool();
            },
            180 => {
                self.choice = RustSourceQC181;
                self.c181 = decoder.read_bool();
            },
            181 => {
                self.choice = RustSourceQC182;
                self.c182 = decoder.read_bool();
            },
            182 => {
                self.choice = RustSourceQC183;
                self.c183 = decoder.read_bool();
            },
            183 => {
                self.choice = RustSourceQC184;
                self.c184 = decoder.read_bool();
            },
            184 => {
                self.choice = RustSourceQC185;
                self.c185 = decoder.read_bool();
            },
            185 => {
                self.choice = RustSourceQC186;
                self.c186 = decoder.read_bool();
            },
            186 => {
                self.choice = RustSourceQC187;
                self.c187 = decoder.read_bool();
            },
            187 => {
                self.choice = RustSourceQC188;
                self.c188 = decoder.read_bool();
            },
            188 => {
                self.choice = RustSourceQC189;
                self.c189 = decoder.read_bool();
            },
            189 => {
                self.choice = RustSourceQC190;
                self.c190 = decoder.read_bool();
            },
            190 => {
                self.choice = RustSourceQC191;
                self.c191 = decoder.read_bool();
            },
            191 => {
                self.choice = RustSourceQC192;
                self.c192 = decoder.read_bool();
            },
            192 => {
                self.choice = RustSourceQC193;
                self.c193 = decoder.read_bool();
            },
            193 => {
                self.choice = RustSourceQC194;
                self.c194 = decoder.read_bool();
            },
            194 => {
                self.choice = RustSourceQC195;
                self.c195 = decoder.read_bool();
            },
            195 => {
                self.choice = RustSourceQC196;
                self.c196 = decoder.read_bool();
            },
            196 => {
                self.choice = RustSourceQC197;
                self.c197 = decoder.read_bool();
            },
            197 => {
                self.choice = RustSourceQC198;
                self.c198 = decoder.read_bool();
            },
            198 => {
                self.choice = RustSourceQC199;
                self.c199 = decoder.read_bool();
            },
            199 => {
                self.choice = RustSourceQC200;
                self.c200 = decoder.read_bool();
            },
            200 => {
                self.choice = RustSourceQC201;
                self.c201 = decoder.read_bool();
            },
            201 => {
                self.choice = RustSourceQC202;
                self.c202 = decoder.read_bool();
            },
            202 => {
                self.choice = RustSourceQC203;
                self.c203 = decoder.read_bool();
            },
            203 => {
                self.choice = RustSourceQC204;
                self.c204 = decoder.read_bool();
            },
            204 => {
                self.choice = RustSourceQC205;
                self.c205 = decoder.read_bool();
            },
            205 => {
                self.choice = RustSourceQC206;
                self.c206 = decoder.read_bool();
            },
            206 => {
                self.choice = RustSourceQC207;
                self.c207 = decoder.read_bool();
            },
            207 => {
                self.choice = RustSourceQC208;
                self.c208 = decoder.read_bool();
            },
            208 => {
                self.choice = RustSourceQC209;
                self.c209 = decoder.read_bool();
            },
            209 => {
                self.choice = RustSourceQC210;
                self.c210 = decoder.read_bool();
            },
            210 => {
                self.choice = RustSourceQC211;
                self.c211 = decoder.read_bool();
            },
            211 => {
                self.choice = RustSourceQC212;
                self.c212 = decoder.read_bool();
            },
            212 => {
                self.choice = RustSourceQC213;
                self.c213 = decoder.read_bool();
            },
            213 => {
                self.choice = RustSourceQC214;
                self.c214 = decoder.read_bool();
            },
            214 => {
                self.choice = RustSourceQC215;
                self.c215 = decoder.read_bool();
            },
            215 => {
                self.choice = RustSourceQC216;
                self.c216 = decoder.read_bool();
            },
            216 => {
                self.choice = RustSourceQC217;
                self.c217 = decoder.read_bool();
            },
            217 => {
                self.choice = RustSourceQC218;
                self.c218 = decoder.read_bool();
            },
            218 => {
                self.choice = RustSourceQC219;
                self.c219 = decoder.read_bool();
            },
            219 => {
                self.choice = RustSourceQC220;
                self.c220 = decoder.read_bool();
            },
            220 => {
                self.choice = RustSourceQC221;
                self.c221 = decoder.read_bool();
            },
            221 => {
                self.choice = RustSourceQC222;
                self.c222 = decoder.read_bool();
            },
            222 => {
                self.choice = RustSourceQC223;
                self.c223 = decoder.read_bool();
            },
            223 => {
                self.choice = RustSourceQC224;
                self.c224 = decoder.read_bool();
            },
            224 => {
                self.choice = RustSourceQC225;
                self.c225 = decoder.read_bool();
            },
            225 => {
                self.choice = RustSourceQC226;
                self.c226 = decoder.read_bool();
            },
            226 => {
                self.choice = RustSourceQC227;
                self.c227 = decoder.read_bool();
            },
            227 => {
                self.choice = RustSourceQC228;
                self.c228 = decoder.read_bool();
            },
            228 => {
                self.choice = RustSourceQC229;
                self.c229 = decoder.read_bool();
            },
            229 => {
                self.choice = RustSourceQC230;
                self.c230 = decoder.read_bool();
            },
            230 => {
                self.choice = RustSourceQC231;
                self.c231 = decoder.read_bool();
            },
            231 => {
                self.choice = RustSourceQC232;
                self.c232 = decoder.read_bool();
            },
            232 => {
                self.choice = RustSourceQC233;
                self.c233 = decoder.read_bool();
            },
            233 => {
                self.choice = RustSourceQC234;
                self.c234 = decoder.read_bool();
            },
            234 => {
                self.choice = RustSourceQC235;
                self.c235 = decoder.read_bool();
            },
            235 => {
                self.choice = RustSourceQC236;
                self.c236 = decoder.read_bool();
            },
            236 => {
                self.choice = RustSourceQC237;
                self.c237 = decoder.read_bool();
            },
            237 => {
                self.choice = RustSourceQC238;
                self.c238 = decoder.read_bool();
            },
            238 => {
                self.choice = RustSourceQC239;
                self.c239 = decoder.read_bool();
            },
            239 => {
                self.choice = RustSourceQC240;
                self.c240 = decoder.read_bool();
            },
            240 => {
                self.choice = RustSourceQC241;
                self.c241 = decoder.read_bool();
            },
            241 => {
                self.choice = RustSourceQC242;
                self.c242 = decoder.read_bool();
            },
            242 => {
                self.choice = RustSourceQC243;
                self.c243 = decoder.read_bool();
            },
            243 => {
                self.choice = RustSourceQC244;
                self.c244 = decoder.read_bool();
            },
            244 => {
                self.choice = RustSourceQC245;
                self.c245 = decoder.read_bool();
            },
            245 => {
                self.choice = RustSourceQC246;
                self.c246 = decoder.read_bool();
            },
            246 => {
                self.choice = RustSourceQC247;
                self.c247 = decoder.read_bool();
            },
            247 => {
                self.choice = RustSourceQC248;
                self.c248 = decoder.read_bool();
            },
            248 => {
                self.choice = RustSourceQC249;
                self.c249 = decoder.read_bool();
            },
            249 => {
                self.choice = RustSourceQC250;
                self.c250 = decoder.read_bool();
            },
            250 => {
                self.choice = RustSourceQC251;
                self.c251 = decoder.read_bool();
            },
            251 => {
                self.choice = RustSourceQC252;
                self.c252 = decoder.read_bool();
            },
            252 => {
                self.choice = RustSourceQC253;
                self.c253 = decoder.read_bool();
            },
            253 => {
                self.choice = RustSourceQC254;
                self.c254 = decoder.read_bool();
            },
            254 => {
                self.choice = RustSourceQC255;
                self.c255 = decoder.read_bool();
            },
            255 => {
                self.choice = RustSourceQC256;
                self.c256 = decoder.read_bool();
            },
            256 => {
                self.choice = RustSourceQC257;
                self.c257 = decoder.read_bool();
            },
            _ => decoder.abort(Error::BadChoice);
        }
    }
}

/// Type AC in module RustSource.
#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceAC {
    pub a: RustSourceQ,
    pub b: RustSourceD
}

impl RustSourceAC {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        self.a.encode_inner(&mut encoder);
        self.b.encode_inner(&mut encoder);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.a.decode_inner(&mut decoder);
        self.b.decode_inner(&mut decoder);
    }
}

/// Type B in module RustSource.
#[derive(Debug, PartialEq, Copy, Clone)]
pub enum RustSourceB {
    A(i8),
    B(RustSourceA)
}

impl RustSourceB {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        match self {
            A(choice) => {
                encoder.append_non_negative_binary_integer(0, 2);
                encoder.append_i8(self.a);
            },
            B(choice) => {
                encoder.append_non_negative_binary_integer(1, 2);
                self.b.encode_inner(&mut encoder);
            },
            C(choice) => {
                encoder.append_non_negative_binary_integer(2, 2);
            },
            _ => encoder.abort(Error::BadChoice);
        }
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        match decoder.read_non_negative_binary_integer(2) {
            0 => {
                self.choice = RustSourceBA;
                self.a = decoder.read_i8();
            },
            1 => {
                self.choice = RustSourceBB;
                self.b.decode_inner(&mut decoder);
            },
            2 => {
                self.choice = RustSourceBC;
            },
            _ => decoder.abort(Error::BadChoice);
        }
    }
}

/// Type C in module RustSource.
let length: u8;
RustSourceB elements[2];

impl RustSourceC {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.length - 0) as u64,
            2);

        for i in 0..self.length {
            self.elements[i].encode_inner(&mut encoder);
        }
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.length = decoder.read_non_negative_binary_integer(2);
        self.length += 0;

        if self.length > 2 {
            decoder.abort(Error::BadLength);

            return;
        }

        for i in 0..self.length {
            self.elements[i].decode_inner(&mut decoder);
        }
    }
}

/// Type E in module RustSource.
#[derive(Debug, PartialEq, Copy, Clone)]
pub enum RustSourceEAB {
    C(bool)
}

#[derive(Debug, PartialEq, Copy, Clone)]
pub enum RustSourceEA {
    pub b: RustSourceEAB
}

#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceE {
    pub a: RustSourceEA
}

impl RustSourceE {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        match self {
            B(choice) => {
                encoder.append_non_negative_binary_integer(0, 0);

                match self {
                    C(choice_2) => {
                        encoder.append_non_negative_binary_integer(0, 0);
                        encoder.append_bool(self.a.b.c);
                    },
                    _ => encoder.abort(Error::BadChoice);
                }
            },
            _ => encoder.abort(Error::BadChoice);
        }
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        match decoder.read_non_negative_binary_integer(0) {
            0 => {
                self.a.choice = RustSourceEAB;

                match decoder.read_non_negative_binary_integer(0) {
                    0 => {
                        self.a.b.choice = RustSourceEABC;
                        self.a.b.c = decoder.read_bool();
                    },
                    _ => decoder.abort(Error::BadChoice);
                }
            },
            _ => decoder.abort(Error::BadChoice);
        }
    }
}

/// Type F in module RustSource.
let length: u8;
struct {
    bool elements[1];
} elements[2];

impl RustSourceF {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.length - 1) as u64,
            1);

        for i in 0..self.length {
            for i_2 in 0..1 {
                encoder.append_bool(self.elements[i].elements[i_2]);
            }
        }
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.length = decoder.read_non_negative_binary_integer(1);
        self.length += 1;

        for i in 0..self.length {
            for i_2 in 0..1 {
                self.elements[i].elements[i_2] = decoder.read_bool();
            }
        }
    }
}

/// Type G in module RustSource.
#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceG {
    pub is_a_present: bool,
    pub a: bool,
    pub is_b_present: bool,
    pub b: bool,
    pub is_c_present: bool,
    pub c: bool,
    pub is_d_present: bool,
    pub d: bool,
    pub is_e_present: bool,
    pub e: bool,
    pub is_f_present: bool,
    pub f: bool,
    pub is_g_present: bool,
    pub g: bool,
    pub is_h_present: bool,
    pub h: bool,
    pub is_i_present: bool,
    pub i: bool
}

impl RustSourceG {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_bit(self.is_a_present as u8);
        encoder.append_bit(self.is_b_present as u8);
        encoder.append_bit(self.is_c_present as u8);
        encoder.append_bit(self.is_d_present as u8);
        encoder.append_bit(self.is_e_present as u8);
        encoder.append_bit(self.is_f_present as u8);
        encoder.append_bit(self.is_g_present as u8);
        encoder.append_bit(self.is_h_present as u8);
        encoder.append_bit(self.is_i_present as u8);

        if src.is_a_present {
            encoder.append_bool(self.a);
        }

        if src.is_b_present {
            encoder.append_bool(self.b);
        }

        if src.is_c_present {
            encoder.append_bool(self.c);
        }

        if src.is_d_present {
            encoder.append_bool(self.d);
        }

        if src.is_e_present {
            encoder.append_bool(self.e);
        }

        if src.is_f_present {
            encoder.append_bool(self.f);
        }

        if src.is_g_present {
            encoder.append_bool(self.g);
        }

        if src.is_h_present {
            encoder.append_bool(self.h);
        }

        if src.is_i_present {
            encoder.append_bool(self.i);
        }
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.is_a_present = decoder.read_bit() != 0;
        self.is_b_present = decoder.read_bit() != 0;
        self.is_c_present = decoder.read_bit() != 0;
        self.is_d_present = decoder.read_bit() != 0;
        self.is_e_present = decoder.read_bit() != 0;
        self.is_f_present = decoder.read_bit() != 0;
        self.is_g_present = decoder.read_bit() != 0;
        self.is_h_present = decoder.read_bit() != 0;
        self.is_i_present = decoder.read_bit() != 0;

        if dst.is_a_present {
            self.a = decoder.read_bool();
        }

        if dst.is_b_present {
            self.b = decoder.read_bool();
        }

        if dst.is_c_present {
            self.c = decoder.read_bool();
        }

        if dst.is_d_present {
            self.d = decoder.read_bool();
        }

        if dst.is_e_present {
            self.e = decoder.read_bool();
        }

        if dst.is_f_present {
            self.f = decoder.read_bool();
        }

        if dst.is_g_present {
            self.g = decoder.read_bool();
        }

        if dst.is_h_present {
            self.h = decoder.read_bool();
        }

        if dst.is_i_present {
            self.i = decoder.read_bool();
        }
    }
}

/// Type H in module RustSource.
dummy: u8;

impl RustSourceH {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        (void)src_p;
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        (void)dst_p;
    }
}

/// Type I in module RustSource.
struct RustSourceI {
pub buf: [u8; 24]

impl RustSourceI {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_bytes(&self.buf);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        decoder.read_bytes(&mut self.buf);
    }
}

/// Type J in module RustSource.
struct RustSourceJ {
let length: u8;
pub buf: [u8; 23]

impl RustSourceJ {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.length - 22) as u64,
            1);
        encoder.append_bytes(&self.buf,
                             self.length);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.length = decoder.read_non_negative_binary_integer(
            1);
        self.length += 22;
        decoder.read_bytes(&mut self.buf,
                           self.length);
    }
}

/// Type K in module RustSource.
#[derive(Debug, PartialEq, Copy, Clone)] value;
pub enum RustSourceK {
    A,
}

impl Default for RustSourceK {
    fn default() -> Self {
        RustSourceK::A
    }
}

impl RustSourceK {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(self.value, 0);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_non_negative_binary_integer(0);
    }
}

/// Type L in module RustSource.
struct RustSourceL {
let length: u32;
pub buf: [u8; 500]

impl RustSourceL {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.length - 0) as u64,
            9);
        encoder.append_bytes(&self.buf,
                             self.length);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.length = decoder.read_non_negative_binary_integer(
            9);
        self.length += 0;

        if self.length > 500 {
            decoder.abort(Error::BadLength);

            return;
        }

        decoder.read_bytes(&mut self.buf,
                           self.length);
    }
}

/// Type O in module RustSource.
let length: u32;
bool elements[260];

impl RustSourceO {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.length - 1) as u64,
            9);

        for i in 0..self.length {
            encoder.append_bool(self.elements[i]);
        }
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.length = decoder.read_non_negative_binary_integer(9);
        self.length += 1;

        if self.length > 260 {
            decoder.abort(Error::BadLength);

            return;
        }

        for i in 0..self.length {
            self.elements[i] = decoder.read_bool();
        }
    }
}

/// Type N in module RustSource.
#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceN {
    pub a: RustSourceK,
    pub b: RustSourceA,
    pub c: RustSourceO
}

impl RustSourceN {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        self.a.encode_inner(&mut encoder);
        self.b.encode_inner(&mut encoder);
        self.c.encode_inner(&mut encoder);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.a.decode_inner(&mut decoder);
        self.b.decode_inner(&mut decoder);
        self.c.decode_inner(&mut decoder);
    }
}

/// Type M in module RustSource.
#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceM {
    pub a: RustSourceK,
    pub b: RustSourceN
}

impl RustSourceM {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        self.a.encode_inner(&mut encoder);
        self.b.encode_inner(&mut encoder);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.a.decode_inner(&mut decoder);
        self.b.decode_inner(&mut decoder);
    }
}

/// Type P in module RustSource.
#[derive(Debug, Default, PartialEq, Copy, Clone)]
pub struct RustSourceP {
    pub a: RustSourceA,
    pub b: RustSourceM,
    pub c: RustSourceF
}

impl RustSourceP {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        self.a.encode_inner(&mut encoder);
        self.b.encode_inner(&mut encoder);
        self.c.encode_inner(&mut encoder);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.a.decode_inner(&mut decoder);
        self.b.decode_inner(&mut decoder);
        self.c.decode_inner(&mut decoder);
    }
}

/// Type R in module RustSource.
i8 value;

impl RustSourceR {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.value - -1) as u64,
            1);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_non_negative_binary_integer(1) as i8;
        self.value += -1;
    }
}

/// Type S in module RustSource.
i8 value;

impl RustSourceS {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.value - -2) as u64,
            2);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_non_negative_binary_integer(2) as i8;
        self.value += -2;
    }
}

/// Type T in module RustSource.
i8 value;

impl RustSourceT {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.value - -1) as u64,
            2);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_non_negative_binary_integer(2) as i8;
        self.value += -1;
    }
}

/// Type U in module RustSource.
i8 value;

impl RustSourceU {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.value - -64) as u64,
            7);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_non_negative_binary_integer(7) as i8;
        self.value += -64;
    }
}

/// Type V in module RustSource.
i8 value;

impl RustSourceV {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_i8(self.value);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_i8();
    }
}

/// Type W in module RustSource.
i16 value;

impl RustSourceW {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.value - -1) as u64,
            9);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_non_negative_binary_integer(9) as i16;
        self.value += -1;
    }
}

/// Type X in module RustSource.
i16 value;

impl RustSourceX {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.value - -2) as u64,
            10);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_non_negative_binary_integer(10) as i16;
        self.value += -2;
    }
}

/// Type Y in module RustSource.
u16 value;

impl RustSourceY {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_non_negative_binary_integer(
            (self.value - 10000) as u64,
            10);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_non_negative_binary_integer(10) as u16;
        self.value += 10000;
    }
}

/// Type Z in module RustSource.
bool value;

impl RustSourceZ {
    pub fn encode(&mut self, mut dst: &mut [u8]) -> Result<usize, Error> {
        let mut encoder = Encoder::new(&mut dst);

        self.encode_inner(&mut encoder);

        encoder.get_result()
    }

    pub fn decode(&mut self, src: &[u8]) -> Result<usize, Error> {
        let mut decoder = Decoder::new(&src);

        self.decode_inner(&mut decoder);

        decoder.get_result()
    }

    fn encode_inner(&mut self, encoder: &mut Encoder) {
        encoder.append_bool(self.value);
    }

    fn decode_inner(&mut self, decoder: &mut Decoder) {
        self.value = decoder.read_bool();
    }
}
