/*
 * Decompiled with CFR 0.152.
 */
package ork.plugins;

import cqure.repeng.ReportObject;
import cqure.repeng.ReportTree;
import java.util.Vector;
import ork.Account;
import ork.AccountList;
import ork.CommonValuesDB;
import ork.Logger;
import ork.OracleDBConnection;
import ork.PasswordItem;
import ork.PasswordItemList;
import ork.SIDList;
import ork.ScannerConfig;
import ork.ServerResult;
import ork.plugins.PluginIface;
import ork.plugins.SysAccountEnumerator;

public class CheckCommonPasswords
implements PluginIface {
    private CommonValuesDB m_oDB;
    private OracleDBConnection m_oOraDBConn;
    private ServerResult m_oRes = null;
    private Logger m_oLogger = new Logger();
    private String m_sServer = null;
    private int m_nPort = -1;
    private SIDList m_oSIDList = null;
    private ScannerConfig m_oConfig = null;
    private ReportTree m_oTree = null;
    private static final int STATUS_SUCCESS = 0;
    private static final int STATUS_RERUN = 1;
    private static final int STATUS_FAILURE = -1;

    public void setCommonValuesDB(CommonValuesDB oDB) {
        this.m_oDB = oDB;
    }

    public void setLogger(Logger oLogger) {
        this.m_oLogger = oLogger;
    }

    public void setParameters(Object o) {
    }

    public void setConfig(ScannerConfig o) {
        this.m_oConfig = o;
    }

    public void setReportTree(ReportTree o) {
        this.m_oTree = o;
    }

    public CheckCommonPasswords(ServerResult oRes) {
        this.m_oRes = oRes;
        this.m_nPort = this.m_oRes.getPort();
        this.m_sServer = this.m_oRes.getServer();
    }

    private int guessDefaultPwOnSID(String sSID, PasswordItemList oList) {
        PasswordItem oItem;
        int nErr = -1;
        SysAccountEnumerator oSysAccEnum = null;
        AccountList oA = this.m_oRes.getAccountList();
        while ((oItem = oList.GetNextItem()) != null) {
            String sUserName = oItem.getUsername();
            String sPassWord = oItem.getPassword();
            if (oA.isAccountsEnumeratedForSID(sSID) && oA.getAccountForUsername(sUserName, sSID) == null) continue;
            this.m_oLogger.debug("[-] Trying " + sUserName + "/" + sPassWord);
            this.m_oOraDBConn = new OracleDBConnection(this.m_sServer, this.m_nPort, sSID);
            if (this.m_oOraDBConn == null) {
                this.m_oLogger.log("[x] Plugin1: Failed to aquire Oracle Connection object");
                return -1;
            }
            this.m_oOraDBConn.setUser(sUserName);
            this.m_oOraDBConn.setPassword(sPassWord);
            nErr = this.m_oOraDBConn.login();
            if (nErr == 0) {
                this.m_oLogger.log("[-] Account " + sUserName + "/" + sPassWord + " found");
                this.m_oRes.addAccount(sSID, sUserName, sPassWord, null, nErr);
                oSysAccEnum = new SysAccountEnumerator(this.m_oOraDBConn.getConnection(), sSID, this.m_oRes, this.m_oLogger);
                if (!oA.isAccountsEnumeratedForSID(sSID) && oSysAccEnum.enumerateSysAccounts()) {
                    oA.setAccountsEnumeratedForSID(sSID);
                    this.m_oOraDBConn.close();
                    return 1;
                }
            } else if (nErr == 28000) {
                this.m_oLogger.log("[-] Account " + sUserName + "/" + sPassWord + " is locked");
                this.m_oRes.addAccount(sSID, sUserName, "", null, nErr);
            } else {
                if (nErr == 17002) {
                    this.m_oLogger.log("[x] Got IO Exception");
                    break;
                }
                if (nErr == 28009) {
                    this.m_oLogger.log("[-] Account " + sUserName + "/" + sPassWord + " requires connect as sysdba");
                    this.m_oRes.addAccount(sSID, sUserName, sPassWord, null, 0);
                } else if (nErr != 1017) {
                    this.m_oLogger.debug("[-] Got error " + nErr);
                }
            }
            this.m_oOraDBConn.close();
        }
        return 0;
    }

    public String padWithSpaces(int nCount) {
        String s = "";
        int i = 0;
        while (i < nCount) {
            s = String.valueOf(s) + " ";
            ++i;
        }
        return s;
    }

    public void report() {
        String sSID;
        Account oA = null;
        AccountList oAList = this.m_oRes.getAccountList();
        SIDList oSIDList = this.m_oRes.getSIDList();
        Vector oUsers = null;
        String sHeader = null;
        String sBody = "";
        String sTmp = "";
        while ((sSID = oSIDList.getNextSID()) != null) {
            sHeader = "Accounts for SID (" + sSID + ")";
            oUsers = oAList.getAccountsForSID(sSID);
            if (oUsers == null) continue;
            int i = 0;
            while (i < oUsers.size()) {
                oA = (Account)oUsers.get(i);
                sTmp = oA.getUsername();
                ReportObject oRo = this.m_oTree.findReportItem(String.valueOf(this.m_sServer) + "/" + sSID + "/Accounts/" + sTmp);
                if (oRo == null) {
                    oRo = new ReportObject(sTmp);
                    this.m_oTree.addReportItem(String.valueOf(this.m_sServer) + "/" + sSID + "/Accounts", oRo);
                }
                oRo.addProperty("Password", oA.getPassword());
                if (oA.getPassword() != null && oA.getPassword().length() > 0) {
                    sTmp = String.valueOf(sTmp) + "/" + oA.getPassword();
                }
                if (oA.getState() == 28000) {
                    sTmp = String.valueOf(sTmp) + this.padWithSpaces(50 - sTmp.length());
                    sBody = String.valueOf(sBody) + sTmp + "[locked]\n";
                    oRo.addProperty("Status", "Locked");
                } else if (oA.getState() == 0) {
                    sTmp = String.valueOf(sTmp) + this.padWithSpaces(50 - sTmp.length());
                    sBody = String.valueOf(sBody) + sTmp + "[open]\n";
                    oRo.addProperty("Status", "Open");
                    oRo.setSeverity(2002);
                } else {
                    sBody = String.valueOf(sBody) + sTmp + "\n";
                }
                ++i;
            }
            sBody.length();
            sBody = "";
        }
    }

    /*
     * Unable to fully structure code
     */
    public int scan() {
        oList = new PasswordItemList();
        this.m_oSIDList = this.m_oRes.getSIDList();
        if (this.m_oSIDList == null) {
            this.m_oLogger.log("[x] Plugin failed to retrieve SID list");
            return -1;
        }
        if (this.m_sServer == null) {
            this.m_oLogger.log("[x] No server has been set");
            return -1;
        }
        if (!oList.LoadPasswordFile("accounts.default", "/")) {
            System.err.println("[x] Plugin1: Failed to open accounts.default");
            return -1;
        }
        if (this.m_oRes != null) ** GOTO lbl23
        this.m_oLogger.log("[x] Plugin1: Serverresult not set");
        return -1;
lbl-1000:
        // 1 sources

        {
            nErr = 0;
            oList.reset();
            if (sSID.toLowerCase().indexOf("extproc") != -1) continue;
            this.m_oLogger.log("[-] Checking sid (" + sSID + ") for common passwords");
            if (!this.m_oTree.addReportItem(String.valueOf(this.m_sServer) + "/" + sSID, new ReportObject("Accounts"))) {
                this.m_oLogger.log("[x] CheckCommonPasswords addReportItem failed");
            }
            while ((nErr = this.guessDefaultPwOnSID(sSID, oList)) == 1) {
            }
lbl23:
            // 3 sources

            ** while ((sSID = this.m_oSIDList.getNextSID()) != null)
        }
lbl24:
        // 1 sources

        this.report();
        return 0;
    }
}

