% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkScalarNA.R
\name{checkScalarNA}
\alias{checkScalarNA}
\alias{check_scalar_na}
\alias{assertScalarNA}
\alias{assert_scalar_na}
\alias{testScalarNA}
\alias{test_scalar_na}
\alias{expect_scalar_na}
\title{Check if an argument is a single missing value}
\usage{
checkScalarNA(x, null.ok = FALSE)

check_scalar_na(x, null.ok = FALSE)

assertScalarNA(x, null.ok = FALSE, .var.name = vname(x), add = NULL)

assert_scalar_na(x, null.ok = FALSE, .var.name = vname(x), add = NULL)

testScalarNA(x, null.ok = FALSE)

test_scalar_na(x, null.ok = FALSE)

expect_scalar_na(x, null.ok = FALSE, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertScalarNA}/\code{assert_scalar_na} return 
 \code{x} invisibly, whereas
 \code{checkScalarNA}/\code{check_scalar_na} and 
 \code{testScalarNA}/\code{test_scalar_na} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertScalarNA}/\code{assert_scalar_na}
 throws an error message, 
 \code{testScalarNA}/\code{test_scalar_na}
 returns \code{FALSE},
 and \code{checkScalarNA}/\code{check_scalar_na} 
 return a string with the error message.
 The function \code{expect_scalar_na} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a single missing value
}
\examples{
testScalarNA(1)
testScalarNA(NA_real_)
testScalarNA(rep(NA, 2))
}
\seealso{
Other scalars: 
\code{\link{checkCount}()},
\code{\link{checkFlag}()},
\code{\link{checkInt}()},
\code{\link{checkNumber}()},
\code{\link{checkScalar}()},
\code{\link{checkString}()}
}
\concept{scalars}
