% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lmfm.R
\name{plot.lmfm}
\alias{plot.lmfm}
\title{Comparison Diagnostic Plots for Linear Regression Models}
\usage{
\method{plot}{lmfm}(x, which.plots = 1:10, ...)
}
\arguments{
\item{x}{an \code{lmfm} object.}

\item{which.plots}{either \code{"ask"} (character string) or an integer
vector specifying which plots to draw. In the later case, the plot numbers
are given above.}

\item{\dots}{additional parameters are ignored.}
}
\value{
\code{x} is invisibly returned.
}
\description{
Produces a set of comparison diagnostic plots.  The plot options are
\enumerate{
  \item Normal QQ Plot of Residuals,
  \item Kernel Density Estimate of Residuals,
  \item Residuals vs. Mahalanobis Distance,
  \item Residuals vs. Fitted Values,
  \item Sqrt Residuals vs. Fitted Values,
  \item Response vs. Fitted Values,
  \item Residuals vs. Index (Time),
  \item Overlaid Normal QQ Plot of Residuals,
  \item Overlaid Kernel Density Estimate of Residuals,
  \item Scatter Plot with Overlaid Fits (for simple linear regression models).
  }
}
\section{Side Effects}{
 The selected plots are drawn on a graphics device.
}

\examples{
data(stackloss)
stack.lm <- lm(stack.loss ~ ., data = stackloss)
stack.clean <- lm(stack.loss ~ ., data = stackloss, subset = 5:20)
fm <- fit.models(stack.clean, stack.lm)
plot(fm)
}
\seealso{
See \code{\link{sideBySideQQPlot}} for 2,
\code{\link{sideBySideKernelDensityPlot}} for 3,
\code{\link{sideBySideIndexPlot}} for 8,
\code{\link{overlaidQQPlot}} for 9,
\code{\link{overlaidKernelDensityPlot}} for 10,
\code{\link{overlaidSimpleRegressionPlot}} for 11, and
\code{\link{sideBySideScatterPlot}} for the others.
}
\keyword{hplot}
\keyword{methods}
